package de.duehl.swing.ui.lights.data;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Enum-Klasse stellt die Art der Anzeige des Elements dar, welches mit kleinen Ampelgrafiken
 * den Fortschritt z.B. des Ergebnisses eine Prüfung anzeigen kann. Dabei werden vier Zustände
 * unterschieden:
 *
 *     1) noch nicht getestet / unbearbeitet (schwarze Ampel)
 *     2) erfolgreich getestet / bearbeitet (grüne Ampel)
 *     3) es traten Warnungen auf (gelbe Ampel)
 *     4) es traten Fehlern auf (rote Ampel)
 *
 * Die unterschiedlichen Arten die hier definiert werden sind:
 *
 *     a) eine einzelne Ampel, die die drei Zustände annehmen kann
 *     b) zwei Ampeln, eine schwarz/grün, die andere schwarz/rot
 *     c) drei Ampeln, eine schwarz/grün, die zweite schwarz/gelb und die dritte schwarz/rot
 *
 * @version 1.01     2025-11-20
 * @author Christian Dühl
 */

public enum CheckLightMode {

    ONE, TWO, THREE;

}
