package de.duehl.swing.ui.panel.painted;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.swing.ui.geometry.PixelPoint;

/**
 * Diese Klasse stellt einen Panel dar, der einen gefüllten Kreis darstellt.
 *
 * @version 1.01     2025-11-22
 * @author Christian Dühl
 */

final public class CirclePanel extends PaintedPanel {

    private static final long serialVersionUID = 1L;

    /** Zeichnet das Symbol in rechteckiger Anordnung. */
    @Override
    protected void paintSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in quadratischer Anordnung. */
    @Override
    protected void paintSymbolSquare() {
        paintSymbol();
    }

    /**
     * Zeichnet den Kreis. Da es dabei egal ist, ob horizontal oder vertikal, wird
     * es in beiden Fällen verwendet.
     */
    private void paintSymbol() {
        int width = getWidth();
        int height = getHeight();

        if (isForceSquare()) {
            width = Math.min(width, height);
            height = width;
        }

        int delta = 6;

        int firstLeftPixel = (getWidth() - width)/2;
        int left = firstLeftPixel + delta;

        int lastRightPixel = firstLeftPixel + width - 1;
        int right = lastRightPixel - delta;

        int firstUpperPixel = (getHeight() - height)/2;
        int upper = firstUpperPixel + delta;

        int lastLowerPixel = firstUpperPixel + height - 1;
        int lower = lastLowerPixel - delta;

        int innerWidth = right - left;
        int innerHeight = lower - upper;
        int centerX = left + innerWidth / 2;
        int centerY = upper + innerHeight / 2;
        PixelPoint center = new PixelPoint(centerX, centerY);


        int halfSmallerWidthOrHeight = Math.min(width, height) / 2;
        int radius = halfSmallerWidthOrHeight - delta;

        paintCircle(center, radius);
    }

}
