package de.duehl.swing.ui.tabs;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für ein Objekt, dass den Status, ob ein Dokument geändert worden ist oder
 * im Originalzustand ist, anzeigen kann.
 *
 * @version 1.01     2017-11-17
 * @author Christian Dühl
 */

public interface ChangeStateDisplayer {

    /** Zeigt an, dass das Dokument geändert worden ist. */
    void signChangedState();

    /** Zeigt an, dass das Dokument im Originalzustand vorliegt. */
    void signUnchangedState();

    /** Ändert den angezeigten Namen. */
    void updateName(String newName);

}
