package de.duehl.swing.ui.text.html;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Enum-Klasse stellt Kenner für die beiden Karten im HtmlPanel dar, diese sind zum einen die
 * eigentliche JEditorPane mit dem Html und zum anderen eine JTextArea mit dem Html-Quellcode.
 *
 * @version 1.01     2020-02-07
 * @author Christian Dühl
 */

public enum HtmlPanelCard {

    HTML("Sourcecode anzeigen"),
    SOURCE_CODE("HTML anzeigen"),
    ;

    /** Der Text, der auf einem Button zum Umschalten angezeigt werden soll. */
    private final String textForToggleButton;

    private HtmlPanelCard(String textForToggleButton) {
        this.textForToggleButton = textForToggleButton;
    }

    /** Getter für den Text, der auf einem Button zum Umschalten angezeigt werden soll. */
    public String getTextForToggleButton() {
        return textForToggleButton;
    }

    /** Gibt die nächste Karte zurück.*/
    public HtmlPanelCard getNext() {
        int actualOrdinal = ordinal();
        int nextOrdinal = actualOrdinal + 1;

        if (nextOrdinal >= values().length) {
            nextOrdinal = 0;
        }

        return values()[nextOrdinal];
        /*
         * Diese Methode ist allgemein formuliert, für beliebig viele Enum-Werte. Bei nur zweien
         * ginge das natürlich deutlich einfacher.
         */
    }

}
