package de.duehl.swing.ui.colors;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.awt.Color;

import org.junit.Test;

public class ColorizerTest {

    @Test
    public void create() {
        Colorizer colorizer = new Colorizer();
        assertNotNull(colorizer);
    }

    @Test
    public void htmlColor1() {
        Colorizer colorizer = new Colorizer();
        Color color = Color.RED;
        String expected = "#FF0000";
        String actual = colorizer.getHTMLColor(color);
        assertEquals(expected, actual);
    }

    @Test
    public void htmlColor2() {
        Colorizer colorizer = new Colorizer();
        Color color = Color.WHITE;
        String expected = "#FFFFFF";
        String actual = colorizer.getHTMLColor(color);
        assertEquals(expected, actual);
    }

    @Test
    public void htmlColor3() {
        Colorizer colorizer = new Colorizer();
        Color color = Color.BLACK;
        String expected = "#000000";
        String actual = colorizer.getHTMLColor(color);
        assertEquals(expected, actual);
    }

}
