package de.duehl.swing.ui.dialogs.lists.logic;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.swing.ui.start.listdialog.logic.DemoLogicalElement;
import de.duehl.swing.ui.start.listdialog.logic.DemoLogicalList;

public class LogicalEditableListBaseTest {

    @Test
    public void creation() {
        DemoLogicalList list = new DemoLogicalList();
        assertNotNull(list);
    }

    @Test
    public void size() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));
        assertEquals(3, list.size());
    }

    @Test
    public void contains() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));
        assertTrue(list.contains(new DemoLogicalElement("Birne")));
    }

    @Test
    public void containsNot() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));
        assertFalse(list.contains(new DemoLogicalElement("Apfelsine")));
    }

    @Test
    public void remove() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));
        assertEquals(3, list.size());
        list.remove(new DemoLogicalElement("Birne"));
        assertEquals(2, list.size());
    }

    @Test (expected = IllegalArgumentException.class)
    public void removeNotContainedFailed() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));
        list.remove(new DemoLogicalElement("Apfelsine"));
    }

    @Test
    public void isElementMovableUp() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));
        assertFalse(list.canMoveUp(new DemoLogicalElement("Apfel")));
        assertTrue(list.canMoveUp(new DemoLogicalElement("Birne")));
        assertTrue(list.canMoveUp(new DemoLogicalElement("Orange")));
    }

    @Test (expected = IllegalArgumentException.class)
    public void isElementMovableUpWithNotContainedElementFailes() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));
        list.canMoveUp(new DemoLogicalElement("Apfelsine"));
    }

    @Test
    public void moveElementUpMiddleElement() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Apfel"), list.get(0));
        assertEquals(new DemoLogicalElement("Birne"), list.get(1));
        assertEquals(new DemoLogicalElement("Orange"), list.get(2));

        list.moveUp(new DemoLogicalElement("Birne"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Birne"), list.get(0));
        assertEquals(new DemoLogicalElement("Apfel"), list.get(1));
        assertEquals(new DemoLogicalElement("Orange"), list.get(2));
    }

    @Test
    public void moveElementUpLastElement() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Apfel"), list.get(0));
        assertEquals(new DemoLogicalElement("Birne"), list.get(1));
        assertEquals(new DemoLogicalElement("Orange"), list.get(2));

        list.moveUp(new DemoLogicalElement("Orange"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Apfel"), list.get(0));
        assertEquals(new DemoLogicalElement("Orange"), list.get(1));
        assertEquals(new DemoLogicalElement("Birne"), list.get(2));
    }

    @Test
    public void moveElementUpDoesNothingWithFirstElement() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Apfel"), list.get(0));
        assertEquals(new DemoLogicalElement("Birne"), list.get(1));
        assertEquals(new DemoLogicalElement("Orange"), list.get(2));

        list.moveUp(new DemoLogicalElement("Apfel"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Apfel"), list.get(0));
        assertEquals(new DemoLogicalElement("Birne"), list.get(1));
        assertEquals(new DemoLogicalElement("Orange"), list.get(2));
    }

    @Test (expected = IllegalArgumentException.class)
    public void moveElementUpFailesWithNotContainedElement() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));

        list.moveUp(new DemoLogicalElement("Apfelsine"));
    }

    @Test
    public void isElementMovableDown() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));
        assertTrue(list.canMoveDown(new DemoLogicalElement("Apfel")));
        assertTrue(list.canMoveDown(new DemoLogicalElement("Birne")));
        assertFalse(list.canMoveDown(new DemoLogicalElement("Orange")));
    }

    @Test (expected = IllegalArgumentException.class)
    public void isElementMovableDownWithNotContainedElementFailes() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));
        list.canMoveDown(new DemoLogicalElement("Apfelsine"));
    }

    @Test
    public void moveElementDownFirstElement() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Apfel"), list.get(0));
        assertEquals(new DemoLogicalElement("Birne"), list.get(1));
        assertEquals(new DemoLogicalElement("Orange"), list.get(2));

        list.moveDown(new DemoLogicalElement("Apfel"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Birne"), list.get(0));
        assertEquals(new DemoLogicalElement("Apfel"), list.get(1));
        assertEquals(new DemoLogicalElement("Orange"), list.get(2));
    }

    @Test
    public void moveElementDownMiddleElement() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Apfel"), list.get(0));
        assertEquals(new DemoLogicalElement("Birne"), list.get(1));
        assertEquals(new DemoLogicalElement("Orange"), list.get(2));

        list.moveDown(new DemoLogicalElement("Birne"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Apfel"), list.get(0));
        assertEquals(new DemoLogicalElement("Orange"), list.get(1));
        assertEquals(new DemoLogicalElement("Birne"), list.get(2));
    }

    @Test
    public void moveElementDownDoesNothingWithLastElement() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Apfel"), list.get(0));
        assertEquals(new DemoLogicalElement("Birne"), list.get(1));
        assertEquals(new DemoLogicalElement("Orange"), list.get(2));

        list.moveDown(new DemoLogicalElement("Orange"));

        assertEquals(3, list.size());
        assertEquals(new DemoLogicalElement("Apfel"), list.get(0));
        assertEquals(new DemoLogicalElement("Birne"), list.get(1));
        assertEquals(new DemoLogicalElement("Orange"), list.get(2));
    }

    @Test (expected = IllegalArgumentException.class)
    public void moveElementDownFailesWithNotContainedElement() {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));

        list.moveDown(new DemoLogicalElement("Apfelsine"));
    }

}
