package de.duehl.swing.ui.handler;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JTextArea;

import de.duehl.swing.ui.GuiTools;

public class HTMLCopyPasteTest {

    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();

        final JFrame frame = new JFrame("HTML Copy & Paste Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        final JEditorPane pane = new JEditorPane("text/html",
                "<html><font color=red>Hello</font><br>\u2663<br>World");
        pane.setTransferHandler(new HtmlCopyPasteTransferHandler());
        pane.setPreferredSize(new Dimension(200, 200));
        //pane.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.RAISED));
        pane.setBorder(BorderFactory.createTitledBorder(""));
        frame.add(pane, BorderLayout.WEST);

//        /*
//         * Hier ohne den HtmlCopyPasteTransferHandler: <p> werden zu
//         * Zeilenumbrüchen!
//         */
//        final JEditorPane pane2 = new JEditorPane("text/html",
//                "<html><font color=red>Hello</font><p>\u2663<p>World");
//        //pane2.setTransferHandler(new HtmlCopyPasteTransferHandler());
//        pane2.setPreferredSize(new Dimension(200, 200));
//        //pane.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.RAISED));
//        pane2.setBorder(BorderFactory.createTitledBorder(""));
//        frame.add(pane2, BorderLayout.CENTER);

        final JTextArea area = new JTextArea("");
        area.setPreferredSize(new Dimension(200, 200));
        //area.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.RAISED));
        area.setBorder(BorderFactory.createTitledBorder(""));
        frame.add(area, BorderLayout.EAST);

        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

}
