package de.duehl.swing.ui.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.painted.FirstButton;
import de.duehl.swing.ui.buttons.painted.LastButton;
import de.duehl.swing.ui.buttons.painted.NextButton;
import de.duehl.swing.ui.buttons.painted.PreviousButton;

/**
 * Diese Klasse testet einige selbstgezeichnete Buttons.
 *
 * @version 1.01     2015-12-16
 * @author Christian Dühl
 */

public class FirstPreviousNextLastSizableTest {

    private static final Dimension BUTTON_DIMENSION = new Dimension(50, 50);

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new FirstPreviousNextLastSizableTest();
    }

    /** Konstruktor. */
    public FirstPreviousNextLastSizableTest() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                createAndShowGUI();
            }
        });
    }

    /** Erstellt die grafische Oberfläche und zeigt sie an. */
    private void createAndShowGUI() {
        GuiTools.setNiceLayoutManager();

        JFrame frame = new JFrame(
                "First-, Previous-, Next- und Last-Button SizableTest");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new GridLayout(2, 4));

        frame.add(createFirstButton(true));
        frame.add(createPreviousButton(true));
        frame.add(createNextButton(true));
        frame.add(createLastButton(true));
        frame.add(createFirstButton(false));
        frame.add(createPreviousButton(false));
        frame.add(createNextButton(false));
        frame.add(createLastButton(false));

        frame.setPreferredSize(new Dimension(280, 150));
        frame.pack();
        frame.setVisible(true);
    }

    private JButton createFirstButton(boolean horizontal) {
        FirstButton button = new FirstButton();
        button.setHorizontal(horizontal);
        button.setPreferredSize(BUTTON_DIMENSION);
        return button;
    }

    private JButton createPreviousButton(boolean horizontal) {
        PreviousButton button = new PreviousButton();
        button.setHorizontal(horizontal);
        button.setPreferredSize(BUTTON_DIMENSION);
        return button;
    }

    private JButton createNextButton(boolean horizontal) {
        NextButton button = new NextButton();
        button.setHorizontal(horizontal);
        button.setPreferredSize(BUTTON_DIMENSION);
        return button;
    }

    private JButton createLastButton(boolean horizontal) {
        LastButton button = new LastButton();
        button.setHorizontal(horizontal);
        button.setPreferredSize(BUTTON_DIMENSION);
        return button;
    }

}
