package de.duehl.swing.ui.start;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

import de.duehl.basics.system.SystemTools;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.painted.GoButton;
import de.duehl.swing.ui.dialogs.logging.LogfileDialog;

/**
 * Diese Klasse testet den LogfileDialog.
 *
 * @version 1.01     2017-05-31
 * @author Christian Dühl
 */

public class LogFileDialogTest {

    private final JFrame frame;

    /** Konstruktor. */
    public LogFileDialogTest() {
        frame = new JFrame();
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                createAndShowGUI();
            }
        });
    }

    /** Erstellt die grafische Oberfläche und zeigt sie an. */
    private void createAndShowGUI() {
        frame.setTitle("LogfileDialog - Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new GridLayout(0,  3));

        frame.add(new JLabel());
        frame.add(new JLabel());
        frame.add(new JLabel());

        frame.add(new JLabel());
        frame.add(createStartButton());
        frame.add(new JLabel());

        frame.add(new JLabel());
        frame.add(new JLabel());
        frame.add(new JLabel());

        frame.setPreferredSize(new Dimension(800, 600));
        frame.pack();
        frame.setVisible(true);
    }

    private Component createStartButton() {
        JButton button = new GoButton();
        button.addActionListener(e -> run());
        return button;
    }

    private void run() {
        String filename = GuiTools.openFileWithExtension(frame, ".log", SystemTools.getHomeDirectory());
        if (!filename.isEmpty()) {
            openDialog(filename);
        }
    }

    private void openDialog(String filename) {
        LogfileDialog dialog = new LogfileDialog(filename, frame.getLocation());
        dialog.setVisible(true);
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new LogFileDialogTest();
    }

}
