package de.duehl.swing.ui.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Dialog.ModalityType;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

/**
 * In einem Projekt fehlen plötzlich die mittleren Anfasser der ScrollBar.
 * Den Unterschied sieht man, wenn man REPEAT von 100 auf 10 wechselt.
 */

public class MissingScrollBarElementsStandAlone {

    private static final int REPEAT = 100;
    private static final boolean LIMIT_MINIMUM_THUMB_SIZE = true;

    public static void main(String[] args) {
        setNiceLayoutManager(); // ohne wird er angezeigt!
        JDialog dialog = createDialog();
        dialog.setVisible(true);
    }

    public static void setNiceLayoutManager() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            /* Dies löst es vorübergehend: */
            if (LIMIT_MINIMUM_THUMB_SIZE) {
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                UIDefaults defaults = lookAndFeel.getDefaults();
                defaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static JDialog createDialog() {
        JDialog dialog = new JDialog();
        dialog.setTitle("Langer Beispieltext");

        dialog.setModalityType(ModalityType.APPLICATION_MODAL);
        dialog.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        dialog.setLayout(new BorderLayout());

        dialog.add(createCenterPart(), BorderLayout.CENTER);

        dialog.pack();
        dialog.setLocation(150, 90);

        return dialog;
    }

    private static Component createCenterPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        JTextArea area = new JTextArea();
        area.setText(getLongLoremIpsumText());
        panel.add(area, BorderLayout.CENTER);

        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(panel);
        scroll.setPreferredSize(new Dimension(800, 600));

        return scroll;
    }

    private static String getLongLoremIpsumText() {
        StringBuilder builder = new StringBuilder();

        for (int i=0; i<REPEAT; ++i) {
            builder.append(getLoremIpsumText());
            if (i < REPEAT - 1) {
                builder.append("\n\n");
            }
        }

        return builder.toString();
    }

    private static String getLoremIpsumText() {
        return "Lorem ipsum dolor sit amet, consectetur adipisici " + "\n"
                + "elit, sed eiusmod tempor incidunt ut labore et dolore " + "\n"
                + "magna aliqua. Ut enim ad minim veniam, quis nostrud " + "\n"
                + "exercitation ullamco laboris nisi ut aliquid ex ea " + "\n"
                + "commodi consequat. Quis aute iure reprehenderit in " + "\n"
                + "voluptate velit esse cillum dolore eu fugiat nulla " + "\n"
                + "pariatur. Excepteur sint obcaecat cupiditat non proident, " + "\n"
                + "sunt in culpa qui officia deserunt mollit anim id est " + "\n"
                + "laborum.";
    }

}
