package de.duehl.swing.ui.start;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JLabel;
import javax.swing.JPanel;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.elements.sidelist.SideListOrganiserPanel;

/**
 * Diese Klasse testet das Organisationselement mit einer Seitenliste und zugehörigen
 * Anzeigelementen.
 *
 * @version 1.01     2024-06-13
 * @author Christian Dühl
 */

public class SideListOrganiserTest extends NonModalFrameDialogBase {

    private static final Dimension DIALOG_DIMENSION = new Dimension(800, 700);

    /** Das Organisationselement mit einer Seitenliste und zugehörigen Anzeigelementen .*/
    private final SideListOrganiserPanel sideListOrganiser;

    /** Konstruktor. */
    public SideListOrganiserTest() {
        super("SideListOrganiser Test", DIALOG_DIMENSION);

        sideListOrganiser = new SideListOrganiserPanel();

        initElements();
        fillDialog();
    }

    private void initElements() {
        sideListOrganiser.addElement("Eintrag eins", createPanel("Inhalt Panel 1"));
        sideListOrganiser.addElement("Eintrag zwei", createPanel("Inhalt Panel 2"));
        sideListOrganiser.addElement("Eintrag drei", createPanel("Inhalt Panel 3"));
        sideListOrganiser.addElement("Eintrag vier", createPanel("Inhalt Panel 4"));
        sideListOrganiser.addElement("Eintrag fünf", createPanel("Inhalt Panel 5"));
        sideListOrganiser.addElement("Eintrag sechs", createPanel("Inhalt Panel 6"));
        sideListOrganiser.addElement("Eintrag sieben", createPanel("Inhalt Panel 7"));
        sideListOrganiser.addElement("Eintrag acht", createPanel("Inhalt Panel 8"));
        sideListOrganiser.addElement("Eintrag neun", createPanel("Inhalt Panel 9"));
        sideListOrganiser.addElement("Eintrag zehn", createPanel("Inhalt Panel 10"));

        //sideListOrganiser.showContent("Eintrag eins");
        sideListOrganiser.showFirstAddedContent();
    }

    private Component createPanel(String text) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createLabel(text), BorderLayout.CENTER);

        return panel;
    }

    private Component createLabel(String text) {
        JLabel label = new JLabel(text);
        GuiTools.biggerFont(label, 25);
        return label;
    }

    /** Baut die Gui auf. */
    @Override
    protected void populateDialog() {
        add(sideListOrganiser.getPanel(), BorderLayout.CENTER);
    }

    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();
        new SideListOrganiserTest().setVisible(true);
    }

}
