package de.duehl.swing.ui.start;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;


public class StringSelectionTest extends NonModalFrameDialogBase {

    private static final Dimension DIALOG_DIMENSION = new Dimension(400, 200);

    private final StringSelection stringSelection;

    public StringSelectionTest() {
        super("", DIALOG_DIMENSION);

        stringSelection = new StringSelection("Regulärer Ausdruck für dei Mengennamen");
        stringSelection.addReturnListener(() -> returnPressedInRegexField());
        stringSelection.addKeyListener(createKeyListener());

        fillDialog();
    }

    private KeyListener createKeyListener() {
        return new KeyListener() {
            @Override
            public void keyTyped(KeyEvent e) {
            }
            @Override
            public void keyReleased(KeyEvent e) {
            }
            @Override
            public void keyPressed(KeyEvent e) {
                System.out.println("Key pressed");
            }
        };
    }

    private void returnPressedInRegexField() {
        System.out.println("Return pressed!");
        String text = stringSelection.getTrimmedText();
        System.out.println("Text = " + text);
    }

    @Override
    protected void populateDialog() {
        add(stringSelection.getPanel(), BorderLayout.CENTER);
    }

    public static void main(String[] args) {
        new StringSelectionTest().setVisible(true);
    }

}
