package de.duehl.swing.ui.start;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.elements.TextLineNumber;

/**
 * Diese Klasse testet TextLineNumber Klasse.
 *
 * @version 1.01     2017-11-20
 * @author Christian Dühl
 */

public class TextLineNumberTest {

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new TextLineNumberTest();
    }

    /** Konstruktor. */
    public TextLineNumberTest() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                createAndShowGUI();
            }
        });
    }

    /** Erstellt die grafische Oberfläche und zeigt sie an. */
    private void createAndShowGUI() {
        JFrame frame = new JFrame("ArrowSelectorTest");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        JTextPane textPane = new JTextPane();
        JScrollPane scrollPane = new JScrollPane(textPane);
        TextLineNumber tln = new TextLineNumber(textPane);
        scrollPane.setRowHeaderView( tln );

        frame.add(scrollPane, BorderLayout.CENTER);

        frame.setPreferredSize(new Dimension(800, 600));
        frame.pack();
        frame.setVisible(true);
    }

}

