package de.duehl.swing.ui.start.watch;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Color;

import javax.swing.JFrame;
import javax.swing.SwingConstants;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.watch.WatchLabel;

public class WatchLabelTest {

    public static void main(String[] args) {
        JFrame frame = new JFrame("WatchLabel Demo");
        frame.setLayout(new BorderLayout());

        WatchLabel label = new WatchLabel();
        label.setHorizontalAlignment(SwingConstants.CENTER);
        label.setForeground(Color.BLACK);
        GuiTools.biggerFont(label, 10);
        frame.add(label, BorderLayout.CENTER);

        frame.setSize(400, 100);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setVisible(true);
    }

}
