package de.duehl.vocabulary.japanese.common.color.data;

/**
 * Diese Enum-Klasse steht für die Art, wie Farben für die Erzeugung von Vorder- bzw.
 * Hintergrundfarben modifiziert werden.
 *
 * @version 1.01     2024-07-30
 * @author Christian Dühl
 */

public enum ColorModificationType {

    ADDITIVE,
    MULTIPLICATIVE,
    ;

    /** Ermittelt den Typ über den Namen. */
    public static ColorModificationType determineByName(String colorModificationTypeName) {
        for (ColorModificationType selectionType : ColorModificationType.values()) {
            String name = selectionType.name();
            if (name.equals(colorModificationTypeName)) {
                return selectionType;
            }
        }

        throw new RuntimeException("Zum Namen '" + colorModificationTypeName
                + "' konnte keine Art der Farben-Modifikation ermittelt werden.");
    }

}
