package de.duehl.vocabulary.japanese.common.data;

/**
 * Diese Enum-Klasse stellt eine Art dar, die Vokabularien in der Oberfläche zu sortieren.
 *
 * @version 1.01     2024-03-21
 * @author Christian Dühl
 */

public enum VocabularySortOrder {

    ALPHABETICAL("alphabetisch"),
    REVERSED_ALPHABETICAL("umgedreht alphabetisch"),

    OLDEST_VOCABULARIES_FIRST("aufsteigend nach Datum"),
    NEWEST_VOCABULARIES_FIRST("absteigend nach Datum"),

    MANUAL_SORT_ORDER("individuell"),
    ;

    /**
     * Die Beschreibung der Sortierung für Drop-Down und den Optionen-Dialog.
     *
     * Dieser wird in der Form
     *     "Vokabularien SORTORDER sortieren."
     * verwendet.
     */
    private final String description;

    /**
     * Konstruktor.
     *
     * @param description
     *            Die Beschreibung der Sortierung für Drop-Down und den Optionen-Dialog.
     *            Dieser wird in der Form
     *                "Vokabularien SORTORDER sortieren."
     *            verwendet
     */
    private VocabularySortOrder(String description) {
        this.description = description;
    }

    /** Getter für die Beschreibung der Sortierung für Drop-Down und den Optionen-Dialog. */
    public String getDescription() {
        return description;
    }

    /** Ermittelt die Reihenfolge über den Namen. */
    public static VocabularySortOrder determineByName(String vocabularySortOrderName) {
        for (VocabularySortOrder sortOrder : VocabularySortOrder.values()) {
            String name = sortOrder.name();
            if (name.equals(vocabularySortOrderName)) {
                return sortOrder;
            }
        }

        throw new RuntimeException("Zum Namen '" + vocabularySortOrderName
                + "' konnte keine Sortierreihenfolge ermittelt werden.");
    }

}
