package de.duehl.vocabulary.japanese.common.website;

/**
 * Diese Klasse hält Konstanten rund um die Dateien und anderen Eigenschaften auf meiner Website
 * bereit, welche zum einen zur Überprüfung und ggf. Download aus dem Vokabel-Trainer (mit Hilfe
 * des Downloads über http) und zum anderen für den Upload neuer Versionen (über SFTP) gennutzt
 * werden.
 *
 * @version 1.01     2024-11-11
 * @author Christian Dühl
 */

public class VocaluaryTrainerWebsiteConstants {

    /**
     * Der Name des Unterverzeichnisses - und gleichzeitig Teil der URL - in dem die Dateien zum
     * Vokabel-Trainer liegen.
     */
    public static final String SERVER_BARE_DIRECTORY = "vokabel_trainer_japanisch";

    /** Die Anfang der URL zur Seite des Vokabel-Trainers. */
    public static final String BASE_URL = "https://www.duehl.de/" + SERVER_BARE_DIRECTORY + "/";



    /** Der Name der Datei mit der neusten Launcher-Version auf dem Webserver. */
    public static final String LAUNCHER_VERSION_BARE_FILENAME_ON_SERVER =
            "Neuste_Version_Launcher.txt";

    /** Der Name der Datei mit der neusten Programm-Version auf dem Webserver. */
    public static final String PROGRAM_VERSION_BARE_FILENAME_ON_SERVER =
            "Neuste_Version_Programm.txt";

    /** Der Name der Datei mit der neusten Version der Vokabeln auf dem Webserver. */
    public static final String VOCABLES_VERSION_BARE_FILENAME_ON_SERVER =
            "Neuste_Version_Vokabeln.txt";

    /**
     * Der Name der Datei mit der neusten Version der ausgewählten eigenen Listen auf dem
     * Webserver.
     */
    public static final String OWN_LISTS_VERSION_BARE_FILENAME_ON_SERVER =
            "Neuste_Version_Listen.txt";



    /** Der Name der Datei mit der Version der Vokabeln im lokalen Vokabel-Verzeichnis. */
    public static final String VOCABLES_VERSION_BARE_FILENAME_IN_LOCAL_VOCABLES_DIR =
            "Version_Vokabeln.txt";



    /** Die URL der Datei mit der neusten Launcher-Version auf dem Webserver. */
    public static final String NEWEST_LAUNCHER_VERSION_ON_SERVER_URL =
            BASE_URL + LAUNCHER_VERSION_BARE_FILENAME_ON_SERVER;

    /** Die URL der Datei mit der neusten Programm-Version auf dem Webserver. */
    public static final String NEWEST_PROGRAM_VERSION_ON_SERVER_URL =
            BASE_URL + PROGRAM_VERSION_BARE_FILENAME_ON_SERVER;

    /** Die URL der Datei mit der neusten Version der Vokabeln auf dem Webserver. */
    public static final String NEWEST_VOCABLES_VERSION_ON_SERVER_URL =
            BASE_URL + VOCABLES_VERSION_BARE_FILENAME_ON_SERVER;

    /**
     * Die URL der Datei mit der neusten Version der ausgewählten eigenen Listen auf dem Webserver.
     */
    public static final String NEWEST_OWN_LISTS_VERSION_ON_SERVER_URL =
            BASE_URL + OWN_LISTS_VERSION_BARE_FILENAME_ON_SERVER;


    /** Der Name der HTML-Datei über den Vokabeltrainer ohne Pfad oder URL. */
    public static final String VOCBULARY_TRAINER_BARE_WEBPAGE_HTML_FILENAME =
            "vokabel_trainer_japanisch.html";

    /** Die Url der Website über den Vokabeltrainer für die Prüfung auf Updates. */
    public static final String VOCBULARY_TRAINER_WEBPAGE_URL =
            BASE_URL + VOCBULARY_TRAINER_BARE_WEBPAGE_HTML_FILENAME;

    /**
     * Die Kurzform Url der Website über den Vokabeltrainer für die Prüfung auf Updates
     * (funktioniert dank index.html mit Redirect .
     */
    public static final String SHORT_VOCBULARY_TRAINER_WEBPAGE_URL = BASE_URL;

}
