package de.duehl.vocabulary.japanese.common.website.update.program;

import static de.duehl.vocabulary.japanese.common.website.VocaluaryTrainerWebsiteConstants.NEWEST_PROGRAM_VERSION_ON_SERVER_URL;
import static de.duehl.vocabulary.japanese.common.website.download.WebsiteFileContentDownloader.downloadFileViaUrlFromServerAndGetContentOfFirstLine;

/**
 * Diese Klasse stellt Hilfsmethoden rund um das Updates des Programms zur Verfügung.
 *
 * @version 1.01     2024-11-11
 * @author Christian Dühl
 */

public class ProgramUpdaterTools {

    /**
     * Lädt die erste Zeile der Datei mit der Version des Programms auf dem Webserver herunter.
     *
     * Hatte das Herunterladen keinen Erfolg, so wird NO_DOWNLOAD_SUCCESS zurückgegeben.
     */
    public static String downloadProgramVersionFromServer() {
        return downloadFileViaUrlFromServerAndGetContentOfFirstLine(
                NEWEST_PROGRAM_VERSION_ON_SERVER_URL);
    }

}
