package de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data;

/**
 * Diese Enum-Klasse steht für die Art, wie Kanji zum Abtesten ausgewählt werden.
 *
 * @version 1.01     2025-06-27
 * @author Christian Dühl
 */

public enum KanjiForTestSelectionMethod {

    UNKNOWN,                   // Nicht initialisiert.
    RANDOM_BY_NUMBER,          // Wählt abhängig von einer übergebene Anzahl so viele Kanji zufällig
                               // aus.
    ALL,                       // Wählt alle Kanji aus.
    LAST_N,                    // Wählt die letzten Kanji abhängig von einer übergebene Anzahl aus.
    NOT_TEN_TIMES_GOOD_TESTED, // Wählt diejenigen Kanji, die nicht mindestens zehn mal getestet
                               // wurden oder die bei den letzten zehn Abfragen nicht zehn mal
                               // korrekt beantwortet wurden.
    OLDEST_TESTED_N,           // Wählt die am längsten nicht mehr abgefragten Kanji abhängig von
                               // einer übergebene Anzahl aus.
    MOST_SELDOM_TESTED_N,      // Wählt die am wenigsten oft abgefragten Kanji abhängig von
                               // einer übergebene Anzahl aus.

}
