package de.duehl.vocabulary.japanese.startup.logic.steps;

import java.util.List;
import java.util.Map;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;

/**
 * Diese Klasse steht für den Schritt der das Datum der ältesten Vokabel jedes Vokabulars in dieses
 * einträgt.
 *
 * @version 1.01     2025-11-23
 * @author Christian Dühl
 */

public class Step06StoreDateOfOldestVocableInEachVocabulary extends StartupStep {

    /** Die Liste mit den bekannten Vokabularien. */
    private final List<Vocabulary> vocabularies;

    /** Das Verzeichnis der internen Daten zu einer Vokabel nach der zugehörigen Variablen. */
    private final Map<Vocable, InternalAdditionalVocableData> vocable2InternalDataMap;

    /**
     * Konstruktor.
     *
     * @param step
     *            Der Schritt der durchgeführt wird.
     * @param options
     *            Die Programmoptionen.
     * @param splashScreen
     *            Die grafische Oberfläche beim Start in der die Meldungen angezeigt werden.
     * @param watch
     *            Misst die Laufzeit des gesamten Startups.
     * @param vocabularies
     *            Die Liste mit den bekannten Vokabularien.
     * @param vocable2InternalDataMap
     *            Das Verzeichnis der internen Daten zu einer Vokabel nach der zugehörigen
     *            Variablen.
     */
    public Step06StoreDateOfOldestVocableInEachVocabulary(String step, Options options,
            SplashScreenable splashScreen, StopWatch watch, List<Vocabulary> vocabularies,
            Map<Vocable, InternalAdditionalVocableData> vocable2InternalDataMap) {
        super(step, options, splashScreen, watch);
        this.vocabularies = vocabularies;
        this.vocable2InternalDataMap = vocable2InternalDataMap;
    }

    /** Führt den eigentlichen Inhalt des Schritts aus. */
    @Override
    protected void runInternalStep() {
        appendMessage("Trage Datum der ältesten Vokabel in allen Vokabularien ein ...");
        for (Vocabulary vocabulary : vocabularies) {
            storeDateOfOldestVocableInVocabulary(vocabulary);
        }
    }

    private void storeDateOfOldestVocableInVocabulary(Vocabulary vocabulary) {
        ImmutualDate oldestDate = new ImmutualDate();

        for (Vocable vocable : vocabulary.getVocables()) {
            InternalAdditionalVocableData data = vocable2InternalDataMap.get(vocable);
            ImmutualDate vocableFirstSeenDate = data.getFirstSeenDate();
            if (!vocableFirstSeenDate.equals(InternalAdditionalVocableData.NOT_SEEN_DATE)
                    && vocableFirstSeenDate.before(oldestDate)) {
                oldestDate = vocableFirstSeenDate;
            }
        }

        vocabulary.setFirstSeenDate(oldestDate);
    }

}
