package de.duehl.vocabulary.japanese.startup.logic.steps;

import java.util.List;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.translation.JapaneseToGermanTranslation;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;

/**
 * Diese Klasse steht für den Schritt der die Japanisch-Deutschen Übersetzungen erzeugt.
 *
 * @version 1.01     2025-11-23
 * @author Christian Dühl
 */

public class Step07CreateJapaneseToGermanTranslation extends StartupStep {

    /** Die Liste mit den bekannten Vokabularien. */
    private final List<Vocabulary> vocabularies;

    /**
     * Das Objekt das sich um die Übersetzung von Japanisch in Deutsch kümmert (für Abfragen die
     * nur Kana, aber nicht Kanji anzeigen).
     */
    private JapaneseToGermanTranslation japaneseToGermanTranslation;

    /**
     * Konstruktor.
     *
     * @param step
     *            Der Schritt der durchgeführt wird.
     * @param options
     *            Die Programmoptionen.
     * @param splashScreen
     *            Die grafische Oberfläche beim Start in der die Meldungen angezeigt werden.
     * @param watch
     *            Misst die Laufzeit des gesamten Startups.
     * @param vocabularies
     *            Die Liste mit den bekannten Vokabularien.
     */
    public Step07CreateJapaneseToGermanTranslation(String step, Options options,
            SplashScreenable splashScreen, StopWatch watch, List<Vocabulary> vocabularies) {
        super(step, options, splashScreen, watch);
        this.vocabularies = vocabularies;
    }

    /** Führt den eigentlichen Inhalt des Schritts aus. */
    @Override
    protected void runInternalStep() {
        appendMessage("Erzeuge Datenstrukturen für die Zuordnung von Kana und Kanji zu Vokabeln "
                + "sowie mehrdeutige Zuordnungen von Kana ohne Kanji zu Vokabeln für die "
                + "Übersetzung von Japanisch in Deutsch ...");
        japaneseToGermanTranslation = new JapaneseToGermanTranslation(vocabularies);
    }

    /**
     * Getter für das Objekt das sich um die Übersetzung von Japanisch in Deutsch kümmert (für
     * Abfragen die nur Kana, aber nicht Kanji anzeigen).
     */
    public JapaneseToGermanTranslation getJapaneseToGermanTranslation() {
        return japaneseToGermanTranslation;
    }

}

