package de.duehl.vocabulary.japanese.startup.logic.steps;

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;

/**
 * Diese Klasse steht für den Schritt der überprüft, ob es bei den Kanji jedes Kanji-Zeichen nur
 * einmal gibt.
 *
 * Es war einmal vorgekommen, dass ich ein Kanji unter zwei unterschiedlichen Namen zweimal in der
 * Kanji-Enum-Klasse hatte (HIMMEL und HIMMEL_PARADIES).
 *
 * @version 1.01     2025-11-23
 * @author Christian Dühl
 */

public class Step11CheckDoubleKanji extends StartupStep {

    /**
     * Konstruktor.
     *
     * @param step
     *            Der Schritt der durchgeführt wird.
     * @param options
     *            Die Programmoptionen.
     * @param splashScreen
     *            Die grafische Oberfläche beim Start in der die Meldungen angezeigt werden.
     * @param watch
     *            Misst die Laufzeit des gesamten Startups.
     */
    public Step11CheckDoubleKanji(String step, Options options, SplashScreenable splashScreen,
            StopWatch watch) {
        super(step, options, splashScreen, watch);
    }

    /** Führt den eigentlichen Inhalt des Schritts aus. */
    @Override
    protected void runInternalStep() {
        appendMessage("Prüfe Kanji auf Dublettenfreiheit ...");
        List<String> seenKanjiCharacters = new ArrayList<>();

        List<String> errors = new ArrayList<>();

        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            String character = kanji.getCharacter();
            if (seenKanjiCharacters.contains(character)) {
                String message = "zum kanji '" + character + "' sind mehr als ein "
                        + "enum-element in der klasse kanji hinterlegt.";
                errors.add(message);
                appendMessage("    " + message);
            }
            seenKanjiCharacters.add(character);
        }

        if (!errors.isEmpty()) {
            errorsInStep(Text.joinWithLineBreak(errors));
        }
    }

}
