package de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.data.GrammarFormAndStringSelection;

import static de.duehl.vocabulary.japanese.common.persistence.GrammarTableHeaderPersistenceHelper.GRAMMAR_TABLE_HEADER_INNER_DIVIDER;
import static de.duehl.vocabulary.japanese.common.persistence.GrammarTableHeaderPersistenceHelper.GRAMMAR_TABLE_HEADER_OUTER_DIVIDER;

/**
 * Diese Klasse sammelt die Informationen aus den Feldern einer Kategorie des Dialoges zur
 * Bearbeitung der Überschriften für die Erstellung von grammatikalischen Tabellen von Verben oder
 * Adjektiven.
 *
 * @version 1.01     2025-11-29
 * @author Christian Dühl
 */

public class GrammarTableHeaderFieldsToMapCreator {

    /** Die Checkboxen für die Verb- oder Adjektivformen. */
    private final List<GrammarFormAndStringSelection> formAndSelections;

    /** Das Verzeichnis der von mir vorgegebenen Formulierungen zu denen des Benutzers. */
    private final Map<String, String> grammarTableHeadersMap;

    /** Gibt an, ob das Auslesen der Felder erfolgreich war. */
    private boolean success;

    /** Die während des Auslesen aufgetretenen Probleme. */
    private List<String> problems;

    /**
     * Konstruktor.
     *
     * @param formAndSelections
     *            Die Checkboxen für die Verb- oder Adjektivformen.
     * @param grammarTableHeadersMap
     *            Das Verzeichnis der von mir vorgegebenen Formulierungen zu denen des Benutzers.
     */
    public GrammarTableHeaderFieldsToMapCreator(
            List<GrammarFormAndStringSelection> formAndSelections,
            Map<String, String> grammarTableHeadersMap) {
        this.formAndSelections = formAndSelections;
        this.grammarTableHeadersMap = grammarTableHeadersMap;
    }

    public void create() {
        success = true;
        problems = new ArrayList<>();

        for (GrammarFormAndStringSelection formAndSelection : formAndSelections) {
            String myForm = formAndSelection.getGrammarForm();
            StringSelection selection = formAndSelection.getStringSelection();
            String userForm = selection.getTrimmedText();
            if (userForm.isBlank() || userForm.equals(myForm)) {
                grammarTableHeadersMap.remove(myForm);
            }
            else if (userForm.contains(GRAMMAR_TABLE_HEADER_OUTER_DIVIDER)) {
                addContainedWrongTextError(myForm, userForm, GRAMMAR_TABLE_HEADER_OUTER_DIVIDER);
            }
            else if (userForm.contains(GRAMMAR_TABLE_HEADER_INNER_DIVIDER)) {
                addContainedWrongTextError(myForm, userForm, GRAMMAR_TABLE_HEADER_INNER_DIVIDER);
            }
            else {
                grammarTableHeadersMap.put(myForm, userForm);
            }
        }
    }

    private void addContainedWrongTextError(String myForm, String userForm, String wrongText) {
        addError(""
                + "Die vom Benutzer eingegebene Form zu \n"
                + myForm
                + ", nämlich\n"
                + userForm
                + "\n"
                + "enthält die unzulässige Zeichenkette '" + wrongText + "'.");
    }

    private void addError(String message) {
        success = false;
        problems.add(message);
    }

    /** Gibt an, ob das Auslesen der Felder erfolgreich war. */
    public boolean isSuccess() {
        return success;
    }

    /** Getter für die während des Auslesen aufgetretenen Probleme. */
    public List<String> getProblems() {
        return problems;
    }

}
