package de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;

/**
 * Diese Klasse zeigt die Details eines Katakana inklusive der internen Daten des Benutzers an.
 *
 * @version 1.01     2025-02-02
 * @author Christian Dühl
 */

public class KatakanaDetailDialog extends ModalDialogBase {

    private static final int MIN_WIDTH = 700;


    /** Das UI-Komponente, auf der die Daten des Katakana dargestellt werden. */
    private final KatakanaPanel katakanaPanel;

    /** Der Button zum Beenden. */
    private final JButton okButton;

    /**
     * Konstruktor.
     *
     * @param katakana
     *            Das anzuzeigende Katakana.
     * @param requester
     *            Das Objekt das zu einer Katakana die internen, benutzerabhängigen Daten abrufen
     *            kann.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     * @param programImage
     *            Anzuzeigendes ProgrammIcon.
     */
    public KatakanaDetailDialog(Katakana katakana, InternalKanaDataRequester requester,
            Point parentLocation, Image programImage) {
        super(parentLocation, programImage, "Details des zu " + katakana.getCharacter());
        addEscapeBehaviour();

        katakanaPanel = new KatakanaPanel();
        katakanaPanel.showKatakanaAsViewerToo();
        katakanaPanel.showInternalKatakanaDataToo(requester);
        katakanaPanel.createGui();
        katakanaPanel.showKatakana(katakana);

        okButton = new JButton("Beenden");

        init();
        fillDialog();
    }

    private void init() {
        okButton.addActionListener(e -> closeDialog());
    }

    @Override
    protected void populateDialog() {
        add(createDummyWidthLabel(), BorderLayout.NORTH);
        add(createCenterPart(), BorderLayout.CENTER);
        add(createButtonsPart(),  BorderLayout.SOUTH);

        SwingUtilities.invokeLater(() -> okButton.requestFocus());
    }

    private Component createDummyWidthLabel() {
        JLabel label = new JLabel("");
        label.setPreferredSize(new Dimension(MIN_WIDTH, 0));
        return label;
    }

    private Component createCenterPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalLayout(0, VerticalLayout.BOTH));
        GuiTools.createTitle(panel);

        panel.add(katakanaPanel.getPanel());

        return panel;
    }

    private Component createButtonsPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(okButton, BorderLayout.EAST);

        return panel;
    }

}
