package de.duehl.vocabulary.japanese.ui.dialog.kanji.detail;

import java.awt.BorderLayout;
import java.awt.Point;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;

/**
 * Diese Klasse zeigt die Details eines Kanji inklusive der internen Daten des Benutzers an.
 *
 * @version 1.01     2025-12-08
 * @author Christian Dühl
 */

public class KanjiDetailDialog extends ModalDialogBase {

    /** Der Panel auf dem das Kanji mit den Details dargestellt wird. */
    private final KanjiDetailPanel kanjiDetailPanel;

    /**
     * Konstruktor.
     *
     * @param kanji
     *            Das anzuzeigende Kanji.
     * @param dataStructures
     *            Die Datenstrukturen des Vokabeltrainers.
     * @param uiObjects
     *            Die häufig verwendeten Funktionen der grafischen Oberfläche des Vokabeltrainers.
     * @param informer
     *            Die Oberfläche, welche diese Klasse aufruft, auf der man eine GlassPane anzeigen
     *            kann.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     */
    public KanjiDetailDialog(Kanji kanji, FumikoDataStructures dataStructures,
            FumikoUiObjects uiObjects, LongTimeProcessInformer informer, Point parentLocation) {
        super(parentLocation, uiObjects.getProgramImage(), "Details des zu " + kanji.getCharacter());
        addEscapeBehaviour();

        kanjiDetailPanel = new KanjiDetailPanel(kanji, dataStructures, uiObjects, informer,
                getWindowAsComponent(), () -> getLocation(), () -> closeDialog());

        fillDialog();
    }

    @Override
    protected void populateDialog() {
        add(kanjiDetailPanel.getPanel(), BorderLayout.CENTER);
    }

}
