package de.duehl.vocabulary.japanese.ui.dialog.table.kanji;

import de.duehl.swing.ui.tables.BasicTableColumnModel;
import de.duehl.vocabulary.japanese.common.persistence.Options;

/**
 * Diese Klasse stellt das Column-Modell der Tabelle mit den Kanji dar.
 *
 * @version 1.02     2026-01-01
 * @author Christian Dühl
 */

public class KanjiTableColumnModel extends BasicTableColumnModel {

    private static final long serialVersionUID = 1L;

    /**
     * Die Tabelle enthält die folgenden Spalten:
     *     - Die laufende Nummer.
     *     - Das Kanji in UTF-8 Darstellung.
     *     - Die deutsche Beschreibung.
     *     - Das Wort in Kanji und Hiragana in der häufigsten Bedeutung.
     *     - Das Wort in Hiragana in der häufigsten Bedeutung.
     *     - Die Nummer des Kanji im Buch "Kanji und Kana" von Wolfgang Hadamitzky.
     *     - Die Seite auf der das Kanji im Buch "Kanji und Kana" von W. Hadamitzky zu finden ist.
     *     - Optional: Nummer in meinem Kanji-Heft.
     *     - Die Liste der sinojapanischen ON-Lesungen des Kanji (groß geschrieben).
     *     - Die Liste der rein japanischen kun-Lesungen des Kanji (klein geschrieben).
     *     - Button zum Betrachten der aller Vokabeln, in denen das Kanji vorkommt.
     * Außerdem die folgenden Spalten aus den internen Kanji-Daten:
     *     - Das Datum an dem das Kanji das erste Mal gesehen wurde.
     *     - Die Anzahl, wie oft das Kanji getestet wurde.
     *     - Die Anzahl, wie oft das Kanji erfolgreich getestet wurde.
     *     - Das Datum des letzten Tests.
     *     - Das Datum des letzten erfolgreichen Tests.
     *     - Das Abschneiden bei den letzten Tests.
     *     - Button zum Betrachten der Kanji mit allen internen Daten
     */
    public KanjiTableColumnModel(Options options) {
        addMinMaxWidthColumn(45, "#");
        addMinWidthColumn(50, "Kanji");
        addMinWidthColumn(120, "Bedeutung");
        addMinWidthColumn(75, "Wort Kanj");
        addMinWidthColumn(75, "Wort Hiragana");
        addMinMaxWidthColumn(60, "Nummer");
        addMinMaxWidthColumn(60, "Seite");
        if (options.isShowKanjiNumberInMyHandwrittenKanjiNotebooks()) {
            addMinMaxWidthColumn(60, "Heft-Nummer");
        }
        addMinWidthColumn(100, "ON-Lesungen");
        addMinWidthColumn(100, "kun-Lesungen");
        addMinMaxWidthColumn(150, "Vokabeln anzeigen");

        addMinMaxWidthColumn(90, "Bekannt seit");
        addMinMaxWidthColumn(60, "Getestet");
        addMinMaxWidthColumn(50, "richtig");
        addMinMaxWidthColumn(90, "zuletzt getestet");
        addMinMaxWidthColumn(90, "zuletzt richtig");
        addMinWidthColumn(100, "letzte 10 Ergebnisse");
        addMinMaxWidthColumn(80, "Interna");
    }

}
