package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail;

import java.awt.BorderLayout;
import java.awt.Point;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;

/**
 * Diese Klasse zeigt eine Vokabel mit den zugehörigen benutzerabhängigen Daten in einem modalen
 * Dialog an.
 *
 * @version 1.01     2025-11-21
 * @author Christian Dühl
 */

public class VocableWithInternaDialog extends ModalDialogBase {

    /** Die anzuzeigende Vokabel. */
    private final Vocable vocable;

    /** Die Datenstrukturen des Vokabeltrainers. */
    private final FumikoDataStructures dataStructures;

    /** Die häufig verwendeten Funktionen der grafischen Oberfläche des Vokabeltrainers. */
    private final FumikoUiObjects uiObjects;

    /**
     * Konstruktor.
     *
     * @param vocable
     *            Die anzuzeigende Vokabel.
     * @param dataStructures
     *            Die Datenstrukturen des Vokabeltrainers.
     * @param uiObjects
     *            Die häufig verwendeten Funktionen der grafischen Oberfläche des Vokabeltrainers.
     * @param parentLocation
     *            Die Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     */
    public VocableWithInternaDialog(Vocable vocable, FumikoDataStructures dataStructures,
            FumikoUiObjects uiObjects, Point parentLocation) {
        super(parentLocation, uiObjects.getProgramImage(),
                "Ansicht einer Vokabel mit den zugehörigen benutzerabhängigen Daten",
                VocableWithInternaPanel.DIALOG_DIMENSION);
        addEscapeBehaviour();

        this.vocable = vocable;
        this.dataStructures = dataStructures;
        this.uiObjects = uiObjects;

        fillDialog();
    }

    /** Baut die Gui auf. */
    @Override
    protected void populateDialog() {
        VocableWithInternaPanel internalPanel = new VocableWithInternaPanel(this, vocable,
                dataStructures, uiObjects, getWindowAsComponent(), (LongTimeProcessInformer) this);
        add(internalPanel.getPanel(), BorderLayout.CENTER);
    }

}
