package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.addtolist;

import java.awt.Point;

import javax.swing.JPanel;

import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;

/**
 * Diese Klasse stellt einen Button bereit, um die veränderliche Vokabel zu einer eigenen Liste
 * hinzuzufügen.
 *
 * @version 1.01     2025-11-20
 * @author Christian Dühl
 */

public class VocableToOwnListAdderWithChangingVocableGui {

    /** Fügt eine Vokabel zu einer eigenen Liste hinzu. */
    private final VocableToOwnListAdder vocableToOwnListAdder;

    /** Der Panel mit dem Button. */
    private final JPanel buttonPanel;

    /**
     * Konstruktor.
     *
     * @param dataStructures
     *            Die Datenstrukturen des Vokabeltrainers.
     * @param uiObjects
     *            Die häufig verwendeten Funktionen der grafischen Oberfläche des Vokabeltrainers.
     * @param location
     *            Die Position des Rahmens der Oberfläche, die den Panel anzeigt, welcher diese
     *            Klasse verwendet.
     */
    public VocableToOwnListAdderWithChangingVocableGui(FumikoDataStructures dataStructures,
            FumikoUiObjects uiObjects, Point location) {
        vocableToOwnListAdder = new VocableToOwnListAdder(dataStructures, uiObjects, location);

        buttonPanel = new JPanel();
        buttonPanel.setLayout(new VerticalLayout(0, VerticalLayout.BOTH));
    }

    /**
     * Fügt zum übergebenen Panel einen Button zur Anzeige der eigenen Listen an, welche die
     * Vokabel enthalten.
     *
     * @param panel
     *            Der Panel dem die Buttons hinzugefügt werden sollen. Dieser sollte ein Layout
     *            haben, das das Hinzufügen von Elemente ohne weitere Parameter gestattet, wie z.B.
     *            das VerticalLayout.
     */
    public void appendButtonToPanel(JPanel panel) {
        panel.add(buttonPanel);
    }

    /** Setter für die Vokabel. */
    public void setVocable(Vocable vocable) {
        updateButtonPanel(vocable);
    }

    private void updateButtonPanel(Vocable vocable) {
        VocableToOwnListAdderButtonCreator creator =
                new VocableToOwnListAdderButtonCreator(vocable, vocableToOwnListAdder);

        buttonPanel.removeAll();
        buttonPanel.add(creator.createAddVocableToListButton());
    }

}
