package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.findlists;

import java.awt.Component;

import javax.swing.JButton;

import de.duehl.vocabulary.japanese.data.Vocable;

/**
 * Diese Klasse stellt einen Button bereit, um zu einer Vokabel alle eigenen Listen zu finden und
 * anzuzeigen, die diese Vokabel enthalten.
 *
 * @version 1.01     2025-07-14
 * @author Christian Dühl
 */

class ListsWithVocableFinderButtonCreator {

    /** Die Vokabel. */
    private final Vocable vocable;

    /** Findet zu einer Vokabel alle Listen, die diese Vokabel enthalten. */
    private final ListsWithVocableFinder listsWithVocableFinder;

    /**
     * Konstruktor.
     *
     * @param vocable
     *            Die Vokabel.
     * @param listsWithVocableFinder
     *            Findet zu einer Vokabel alle Listen, die diese Vokabel enthalten.
     */
    public ListsWithVocableFinderButtonCreator(Vocable vocable,
            ListsWithVocableFinder listsWithVocableFinder) {
        this.vocable = vocable;
        this.listsWithVocableFinder = listsWithVocableFinder;
    }

    public Component createFindListsWithVocableButton() {
        JButton button = new JButton("Listen in denen die Vokabel vorkommt anzeigen.");
        button.addActionListener(e -> listsWithVocableFinder.findListsWithVocable(vocable));
        return button;
    }

}
