package de.duehl.vocabulary.japanese.ui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;

import javax.swing.JPanel;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.swing.ui.move.data.MovingGui;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.logic.wrongtested.WrongTestedVocables;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.components.bars.VocabularyBar;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;

/**
 * Diese Klasse stellt die beiden Listen mit den falsch beantworteten Vokabeln dar.
 *
 * @version 1.01     2025-11-20
 * @author Christian Dühl
 */

public class WrongTestedVocablesUi {

    /** Die Bar für die automatisch gepflegte Liste mit falsch abgefragten Vokabeln aus Gruppen. */
    private final VocabularyBar wrongTestedGroupVocablesBar;

    /**
     * Die Bar für die automatisch gepflegte Liste mit falsch abgefragten Vokabeln aus anderen
     * Vokabularien.
     */
    private final VocabularyBar wrongTestedOtherVocablesBar;

    /** Der Panel auf dem die Bars dargestellt werden. */
    private final JPanel panel;

    /**
     * Konstruktor.
     *
     * @param logic
     *            Die Logik des Vokabel-Trainers.
     * @param gui
     *            Die grafische Oberfläche des Vokabel-Trainers.
     * @param dataStructures
     *            Die Datenstrukturen des Vokabeltrainers.
     * @param uiObjects Die häufig verwendeten Funktionen der grafischen Oberfläche des Vokabeltrainers.
     */
    public WrongTestedVocablesUi(VocabularyTrainerLogic logic, VocabularyTrainerGui gui,
            FumikoDataStructures dataStructures, FumikoUiObjects uiObjects) {
        WrongTestedVocables wrongTestedVocables = dataStructures.getWrongTestedVocables();
        wrongTestedGroupVocablesBar = new VocabularyBar(
                wrongTestedVocables.getWrongTestedGroupVocables(),
                logic, gui, dataStructures, uiObjects,
                createNotReactingMovingGui());
        wrongTestedOtherVocablesBar = new VocabularyBar(
                wrongTestedVocables.getWrongTestedOtherVocables(),
                logic, gui, dataStructures, uiObjects,
                createNotReactingMovingGui());
        panel = new JPanel();

        init();
        buildUi();
    }

    private MovingGui<VocabularyBar> createNotReactingMovingGui() {
        return new MovingGui<>() {
            @Override
            public void moveBarUp(VocabularyBar bar) {
            }
            @Override
            public void moveBarToLast(VocabularyBar bar) {
            }
            @Override
            public void moveBarToFirst(VocabularyBar bar) {
            }
            @Override
            public void moveBarDown(VocabularyBar bar) {
            }
            @Override
            public boolean canBarMoveUp(VocabularyBar bar) {
                return false;
            }
            @Override
            public boolean canBarMoveDown(VocabularyBar bar) {
                return false;
            }
        };
    }

    private void init() {
        panel.setLayout(new BorderLayout());
    }

    private void buildUi() {
        panel.add(createBarsPanel(), BorderLayout.WEST);
    }

    private Component createBarsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalLayout(3,  VerticalLayout.BOTH));

        panel.add(wrongTestedGroupVocablesBar.getPanel());
        panel.add(wrongTestedOtherVocablesBar.getPanel());

        return panel;
    }

    /** Gibt eine Liste mit den hier angezeigten VocabularyBars zurück. */
    public List<VocabularyBar> getVocabularyBars() {
        return CollectionsHelper.buildListFrom(wrongTestedGroupVocablesBar,
                wrongTestedOtherVocablesBar);
    }

    /** Getter für den Panel auf dem die Bars dargestellt werden. */
    public JPanel getPanel() {
        return panel;
    }

}
