package de.duehl.vocabulary.japanese.data.symbol;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

import java.util.List;

public class HiraganaTest {

    @Test
    public void getAllHiraganaAsString() {
        List<String> hiragana = Hiragana.getAllHiraganaAsStringList();
        assertEquals(117, hiragana.size());
        assertEquals(Hiragana.A.getCharacter(), hiragana.get(0));
        assertEquals(Hiragana.SMALL_TSU.getCharacter(), hiragana.get(116));
    }

    @Test
    public void containsHiragana() {
        String text = "Apfel = りんご (ringo)";
        assertTrue(Hiragana.containsHiragana(text));
    }

    @Test
    public void containsOnlyHiraganaSuccess() {
        String text = "りんご";
        assertTrue(Hiragana.containsOnlyHiragana(text));
    }

    @Test
    public void containsOnlyHiraganaSuccess2() {
        String text = "きょうりゅう";
        assertTrue(Hiragana.containsOnlyHiragana(text));
    }

    @Test
    public void containsOnlyHiraganaFail() {
        String text = "Apfel = りんご (ringo)";
        assertFalse(Hiragana.containsOnlyHiragana(text));
    }

    @Test
    public void containsOnlyHiraganaEmptyText() {
        String text = "";
        assertFalse(Hiragana.containsOnlyHiragana(text));
    }

    @Test
    public void firstIndexOfHiragana() {
        String text = "Apfel = りんご (ringo)";
        int actual = Hiragana.firstIndexOfHiragana(text);
        int expected = 8;
        assertEquals(expected, actual);

        int riIndex = text.indexOf("り");
        assertEquals(expected, riIndex);
    }

    @Test
    public void firstIndexOfHiraganaEmptyText() {
        String text = "";
        int actual = Hiragana.firstIndexOfHiragana(text);
        int expected = -1;
        assertEquals(expected, actual);
    }

    @Test
    public void firstIndexOfHiraganaNoHiraganaInText() {
        String text = "Hmmm";
        int actual = Hiragana.firstIndexOfHiragana(text);
        int expected = -1;
        assertEquals(expected, actual);
    }

    @Test
    public void lastIndexOfHiragana() {
        String text = "Apfel = りんご (ringo)";
        int actual = Hiragana.lastIndexOfHiragana(text);
        int expected = 10;
        assertEquals(expected, actual);

        int goIndex = text.indexOf("ご");
        assertEquals(expected, goIndex);
    }

    @Test
    public void lastIndexOfHiraganaEmptyText() {
        String text = "";
        int actual = Hiragana.lastIndexOfHiragana(text);
        int expected = -1;
        assertEquals(expected, actual);
    }

    @Test
    public void lastIndexOfHiraganaNoHiraganaInText() {
        String text = "Hmmm";
        int actual = Hiragana.lastIndexOfHiragana(text);
        int expected = -1;
        assertEquals(expected, actual);
    }

}
