package de.duehl.vocabulary.japanese.tools;

import de.duehl.vocabulary.japanese.data.Vocable;

public class VocablesForTesting {

    public static final Vocable MAKURA = new Vocable()
            .setKana("まくら")
            .setKanji("枕")
            .setRomaji("makura")
            .setPronunciation("maküra")
            .addToTranslations("Kopfkissen")
            .addToTranslations("Kissen")
            .setBareMp3("makura_枕.mp3")
            .setComment("")
            ;

    public static final Vocable KAGAMI = new Vocable()
            .setKana("かがみ")
            .setKanji("鏡")
            .setRomaji("kagami")
            .setPronunciation("kagami")
            .addToTranslations("Spiegel")
            .setBareMp3("kagami_鏡.mp3")
            .setComment("")
            ;

    public static final Vocable AI = new Vocable()
            .setKana("あい")
            .setKanji("愛")
            .setRomaji("ai")
            .setPronunciation("aei")
            .addToTranslations("lieben")
            .addToTranslations("Liebe")
            .setBareMp3("ai_愛.mp3")
            .setComment("Ai als Liebe ist ein großes Wort.")
            ;

    public static final Vocable SEKKEN = new Vocable()
            .setKana("せっけん")
            .setKanji("石鹸")
            .setRomaji("sekken")
            .setPronunciation("sekken")
            .addToTranslations("Seife")
            .setBareMp3("sekken_石鹸.mp3")
            .setComment("")
            ;

    public static final Vocable BEDDO = new Vocable()
            .setKana("ベッド")
            .setKanji("ベッド")
            .setRomaji("beddo")
            .setPronunciation("beddo")
            .addToTranslations("Bett")
            .setBareMp3("beddo_ベッド.mp3")
            .setComment("")
            ;

    public static final Vocable FUTON = new Vocable()
            .setKana("ふとん")
            .setKanji("布団")
            .setRomaji("futon")
            .setPronunciation("fton")
            .addToTranslations("Futon")
            .setBareMp3("futon_布団.mp3")
            .setComment("")
            ;

    public static final Vocable DEMO = new Vocable()
            .setKana("でも")
            .setKanji("でも")
            .setRomaji("demo")
            .setPronunciation("demo")
            .addToTranslations("aber")
            .setBareMp3("demo_でも.mp3")
            .setComment("")
            ;

    public static final Vocable KAGE = new Vocable()
            .setKana("かげ")
            .setKanji("影")
            .setRomaji("kage")
            .setPronunciation("kage")
            .addToTranslations("Schatten")
            .setBareMp3("kage_影.mp3")
            .setComment("")
            ;

}
