package de.duehl.vocabulary.japanese.tools;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class VocabularyToolsTest {

    @Test
    public void vocabularyFilenameToDescriptionVokabelnBettUndBad() {
        String filename =
                "c:/Users/setup/Daten/sprachen/japanisch/vokabeln/Vokabeln_Bett_und_Bad.voc";
        String actual = VocabularyTools.vocabularyFilenameToDescription(filename);
        String expected = "Bett und Bad";
        assertEquals(expected, actual);
    }

    @Test
    public void vocabularyFilenameToDescriptionBettUndBad() {
        String filename =
                "c:/Users/setup/Daten/sprachen/japanisch/vokabeln/Bett_und_Bad.voc";
        String actual = VocabularyTools.vocabularyFilenameToDescription(filename);
        String expected = "Bett und Bad";
        assertEquals(expected, actual);
    }

    @Test
    public void vocabularyFilenameToDescriptionVhs() {
        String filename = ""
                + "d:/daten/dokumente/Sprachen/Japanisch/vokabeln/Vokabeln_VHS_A1/"
                + "Vokabeln_VHS_A1.1/Vokabeln_VHS_A1.1_01_01_Neue_Vokabeln.voc";
        String actual = VocabularyTools.vocabularyFilenameToDescription(filename);
        String expected = "VHS A1.1 01 01 Neue Vokabeln";
        assertEquals(expected, actual);
    }

    @Test
    public void questionMarkCompareName() {
        String translation = "Wie heißt du?";
        String actual = VocabularyTools.createCompareTranslation(translation);
        String expected = "wieheißtdu";
        assertEquals(expected, actual);

        String translation2 = "Wie heißt du";
        String actual2 = VocabularyTools.createCompareTranslation(translation2);
        String expected2 = "wieheißtdu";
        assertEquals(expected2, actual2);
    }

    @Test
    public void hideStartOfVocabularyDescription1() {
        String description = "B1_K02_1_Zählen";
        String actual = VocabularyTools.hideStartOfVocabularyDescriptionStandard(description);
        String expected = "Zählen";
        assertEquals(expected, actual);
    }

    @Test
    public void hideStartOfVocabularyDescription1WithBlank() {
        String description = "B1 K02 1 Zählen";
        String actual = VocabularyTools.hideStartOfVocabularyDescriptionStandard(description);
        String expected = "Zählen";
        assertEquals(expected, actual);
    }

    @Test
    public void hideStartOfVocabularyDescription2() {
        String description = "X_Familie";
        String actual = VocabularyTools.hideStartOfVocabularyDescriptionStandard(description);
        String expected = "Familie";
        assertEquals(expected, actual);
    }

    @Test
    public void hideStartOfVocabularyDescription2WithBlank() {
        String description = "X Familie";
        String actual = VocabularyTools.hideStartOfVocabularyDescriptionStandard(description);
        String expected = "Familie";
        assertEquals(expected, actual);
    }

    @Test
    public void hideStartOfVocabularyDescription3() {
        String description = "VHS_A1.1_01_01_Neue_Vokabeln";
        String actual = VocabularyTools.hideStartOfVocabularyDescriptionStandard(description);
        String expected = "Neue_Vokabeln";
        assertEquals(expected, actual);
    }

    @Test
    public void hideStartOfVocabularyDescription3WithBlank() {
        String description = "VHS A1.1 01 01 Neue Vokabeln";
        String actual = VocabularyTools.hideStartOfVocabularyDescriptionStandard(description);
        String expected = "Neue Vokabeln";
        assertEquals(expected, actual);
    }

    @Test
    public void hideLessStartOfVocabularyDescriptionForVhs() {
        String description = "VHS_A1.1_01_01_Neue_Vokabeln";
        String actual = VocabularyTools.hideLessStartOfVocabularyDescriptionForVhs(description);
        String expected = "01_01_Neue_Vokabeln";
        assertEquals(expected, actual);
    }

    @Test
    public void hideLessStartOfVocabularyDescriptionForVhsWithBlank() {
        String description = "VHS A1.1 01 01 Neue Vokabeln";
        String actual = VocabularyTools.hideLessStartOfVocabularyDescriptionForVhs(description);
        String expected = "01 01 Neue Vokabeln";
        assertEquals(expected, actual);
    }

    @Test
    public void createNameStartRegex() {
        String actual = VocabularyTools.createNameStartRegex();
        String expected = "B1|B2|B3|B4|BD1|VHS[_ ]A1.1|VHS[_ ]A1.2|VHS[_ ]A1.3|VHS[_ ]A2.1|"
                + "Marugoto[_ ]A1|Marugoto[_ ]A2E1|Kumon|X";
        assertEquals(expected, actual);
    }

}
