package de.duehl.zipwithzip4j.unzip;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.IOException;

import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;

/**
 * Diese Klasse kann ein Zip-Archiv auspacken.
 *
 * @version 1.01     2024-11-26
 * @author Christian Dühl
 */

public class UnzipWithZip4J2 {

    /** Der Name des zu entpackenden Archivs. */
    private final String zipFilename;

    /** Das Verzeichnis in das das Archiv ausgepackt werden soll. */
    private final String targetDirectory;

    /** Gibt an, ob das Archiv entschlüsselt werden soll. */
    private boolean cypher;

    /** Das Password im Fall, dass entschlüsselt werden soll. */
    private String password;

    /**
     * Konstruktor.
     *
     * @param zipFilename
     *            Der Name des zu entpackenden Archivs.
     * @param targetDirectory
     *            Das Verzeichnis in das das Archiv ausgepackt werden soll.
     */
    public UnzipWithZip4J2(String zipFilename, String targetDirectory) {
        this.zipFilename = zipFilename;
        this.targetDirectory = targetDirectory;
    }

    /** Gibt an, dass die Datei verschlüsselt werden soll. */
    public void cypher(String password) {
        cypher = true;
        this.password = password;
    }

    /** Führt die Erstellung des Archivs durch. */
    public void unzip() {
        if (cypher) {
            unzipWithPassword();
        }
        else {
            unzipWithoutPassword();
        }
    }

    private void unzipWithPassword() {
        try (ZipFile zip = new ZipFile(zipFilename, password.toCharArray())) {
            zip.extractAll(targetDirectory);
        }
        catch (ZipException exception) {
            throw new RuntimeException(exception);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void unzipWithoutPassword() {
        try (ZipFile zip = new ZipFile(zipFilename)) {
            zip.extractAll(targetDirectory);
        }
        catch (ZipException exception) {
            throw new RuntimeException(exception);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

}
